USE credit;
go

create index lastnameinx on member(lastname)
go

update member set lastname = 'Tripp' where member_no = 1234
go

create proc getmember 
    @ln varchar(15)
as
select * from member where lastname = @ln 
option (recompile)
-- parameter CAN be sniffed (specific plan)
-- but this can lead to PSP (parameter sensitivity problems)
go

exec getmember 'Anderson'						-- gets the plan in cache
exec getmember 'Anderson' with recompile

alter proc getmember 
    @ln varchar(15)
as
declare @lname varchar(15)
set @lname = @ln
select * from member where lastname = @lname -- variable IS UNKNOWN (average plan)
go

alter proc getmember 
    @ln varchar(15)
as
select * from member where lastname = @ln 
OPTION (OPTIMIZE FOR UNKNOWN) -- average plan checking density_vector
go
